function [X_new,Y_new]=Find_Bead(img,radius,X_prd,Y_prd)

% This function finds the bead in the image around the predicted position.
% The technique of cropping the image is used to minimize the time to find
% the bead where 'radius' (the cropping radius of the searching window) is
% based on the phase type. If the bead is not found, the searching window
% will increase by 100 pixels till a bead is found. This function is only
% designed for finding only one bead.


FB=0;% bead is not found
while (FB==0)% loop until the bead is found 

% calculate the starting cropping point   
X1=abs(X_prd-radius);
Y1=abs(Y_prd-radius);
% generate the cropped image 
img_crp = imcrop(img,[X1 Y1 (radius*2) (radius*2)]);
% find the circles in the cropped image
centers = imfindcircles(img_crp,[1 10],'Sensitivity',0.9);
[r, c] = size(centers); % return coordinates of all circles 
X2=abs(X_prd-X1); %
Y2=abs(Y_prd-Y1); %

for  R = 1:r
    
   margin_pos_error=sqrt((centers(R)-X2)^2+(centers(R,c)-Y2)^2); 
if margin_pos_error <= (radius*2) % compare the allowable margin based on radius.
    
               % return the original uncropped image
               X_new = centers(R)+X1; 
               Y_new = centers(R,c)+Y1;
		       disp('the particle arrived to the new position');
               

FB=1;
break; % terminate loop if bead is found.
else % continue loop if bead is not found.
FB=0;
end
end
  if FB==0
     radius=radius+100;
     disp('increasing searching window by 100 pixels');
  end 
end

